<?php
include "lib/mysqlconn.php";
//include "parametros.php";
include "funciones.php";
require "vendor/autoload.php";

$pdo = new Conexion();

$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

if (isset($_SERVER['HTTP_AUTHORIZATION']))
{
  $auth_header = $_SERVER['HTTP_AUTHORIZATION'];
  $token = substr($auth_header, 7);
  $clave_secreta = $_ENV['JWT_SECRET_KEY'];
}
else
{
  header("Token no informado");
  echo "Token no informado";
  exit;
}


if ($_SERVER['REQUEST_METHOD'] == 'GET') {
  if(isset($_GET['id_producto']))
  {
    if (valida_token($token,$clave_secreta))
    {
      $sql = "CALL InsInfoCubiScan(:id_producto,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'L')";
    // $sql = "select * from dilacocl_cubiscan.CubiScan where id_producto = :id_producto";
      $sql = $pdo->prepare($sql);
      $sql->bindValue(':id_producto', $_GET['id_producto']);
      $sql->execute();
      $sql->setFetchMode(PDO::FETCH_ASSOC);
      header("HTTP/1.1 200 Hay datos");
      echo json_encode($sql->fetchAll());
      exit;
    }
  }
  else
  {
    if (valida_token($token,$clave_secreta))
    {
      $sql = "CALL InsInfoCubiScan(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'L')";
      $sql = $pdo->prepare($sql);
      $sql->execute();
      $sql->setFetchMode(PDO::FETCH_ASSOC);
      header("HTTP/1.1 200 hay datos");
      echo json_encode($sql->fetchAll());
      exit;
    }
  }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  if (valida_token($token,$clave_secreta)) 
  {
    $sql = "CALL InsInfoCubiScan(:id_producto,:fecha_ingreso,:largo,:ancho,:alto,:peso,:peso_volumetrico,:oc,:fecha_vencimiento,:lote,:numero_serie,:cantidad,:tipo,'I')";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':id_producto',$_POST['id_producto']);
    $stmt->bindValue(':fecha_ingreso',$_POST['fecha_ingreso']);
    $stmt->bindValue(':largo',$_POST['largo']);
    $stmt->bindValue(':ancho',$_POST['ancho']);
    $stmt->bindValue(':alto',$_POST['alto']);
    $stmt->bindValue(':peso',$_POST['peso']);
    $stmt->bindValue(':peso_volumetrico',$_POST['peso_volumetrico']);
    $stmt->bindValue(':oc',isset($_POST['oc']));
    $stmt->bindValue(':fecha_vencimiento',$_POST['fecha_vencimiento']);
    $stmt->bindValue(':lote',$_POST['lote']);
    $stmt->bindValue(':numero_serie',$_POST['numero_serie']);
    $stmt->bindValue(':cantidad',$_POST['cantidad']);
    $stmt->bindValue(':tipo',$_POST['tipo']);
    $stmt->execute();
    
    $idPost = $pdo->lastInsertId();
    if ($idPost) {
      header("HTTP/1.1 200 OK");
      echo json_encode($idPost);
    }
  }
}

if ($_SERVER['REQUEST_METHOD'] == 'PUT') {
  if (valida_token($token,$clave_secreta)) 
  {
    $sql = "CALL dilacocl_user_scan.InsInfoCubiScan(:id_producto,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'U')";
    $sql = $pdo->prepare($sql);
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':id_producto',isset($_GET['id_producto']));
    $stmt->execute();
    header("HTTP/1.1 200 OK");
  }
}

if ($_SERVER['REQUEST_METHOD'] == 'DELETE') {
  if (valida_token($token,$clave_secreta)) 
  {
    $sql = "CALL dilacocl_user_scan.InsInfoCubiScan(:id_producto,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'E')";
    $sql = $pdo->prepare($sql);
    $sql->bindValue(':id_producto', $_GET['id_producto']);
    $sql->execute();
    $sql->setFetchMode(PDO::FETCH_ASSOC);
    header("HTTP/1.1 200 OK");
    exit;
  }
}
?>